<?php
// Include header
include 'header.php';
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();

// Include the centralized database config file
include 'config.php';

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Check if user is logged in and has status 1
if (!isset($_SESSION['user_id']) || $_SESSION['status'] != 1) {
    header('Location: login.php');
    exit();
}

// Fetch user statistics
$user_count_query = "SELECT COUNT(*) AS total_users FROM users";
$investment_sum_query = "SELECT SUM(investment) AS total_investments FROM users";

$user_count_result = $conn->query($user_count_query);
if (!$user_count_result) {
    die("Error fetching user count: " . $conn->error);
}

$investment_sum_result = $conn->query($investment_sum_query);
if (!$investment_sum_result) {
    die("Error fetching investment sum: " . $conn->error);
}

$user_count = $user_count_result->fetch_assoc()['total_users'];
$investment_sum = $investment_sum_result->fetch_assoc()['total_investments'];

// Fetch user data
$user_data_query = "SELECT id, username, email, contact_number, full_name, mt5username, investment, balance, profit, online FROM users";
$user_data_result = $conn->query($user_data_query);
if (!$user_data_result) {
    die("Error fetching user data: " . $conn->error);
}

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Fetch user-specific statistics
$user_id = $_SESSION['user_id'];
$sql = "SELECT mt5username FROM users WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$stmt->bind_result($mt5username);
$stmt->fetch();
$stmt->close();

$investment_query = "SELECT investment FROM users WHERE mt5username = ?";
$balance_query = "SELECT balance FROM userinfo WHERE mt5username = ?";

$stmt = $conn->prepare($investment_query);
$stmt->bind_param("s", $mt5username);
$stmt->execute();
$stmt->bind_result($investment);
$stmt->fetch();
$stmt->close();

$stmt = $conn->prepare($balance_query);
$stmt->bind_param("s", $mt5username);
$stmt->execute();
$stmt->bind_result($balance);
$stmt->fetch();
$stmt->close();

// Close database connection
$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <link rel="stylesheet" href="styles.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <style>
    .body {
        color: #c5b170;   
    }
    </style>
</head>
<body>
<br><br>
<div class="r1">
<br><br>
    <div class="container">

<?php
// Display the mt5username in an <h2> element
if ($mt5username) {
    echo "<h2>MT5 Account: $mt5username</h2>";
} else {
    echo "<h2>No MT5 Username found.</h2>";
}
?>

<style>
    body {
        font-size: 14px; /* Smaller font size for smaller screens */
        margin-top: 100px; 
    }
    .container {
        padding: 10px; /* Adjust padding or margins if needed */
    }
/* Container for chart and sticky note */
.chart-and-note {
    display: flex;
    align-items: flex-start;
    width: 100%; /* Ensures it takes up available space */
    max-width: 1200px; /* Adjust as needed for layout */
}

/* Styling for the chart */
#statsChart {
    flex: 1;
    margin-right: 20px; /* Space between chart and sticky note */
}

/* Sticky note styling */
.sticky-note {
    background-color: rgba(50, 50, 50, 0.2); /* Dark grey with slight transparency */
    border: 2px solid #555; /* Slightly lighter grey border */
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.6); /* Deep shadow */
    border-radius: 10px;
    padding: 20px;
    width: 300px;
    height: 370px;
    color: #d7d1ac; /* Light gold text */
    display: flex;
    flex-direction: column;
}

/* Sticky note textarea styling */
.sticky-note textarea {
    width: 100%;
    height: 80%;
    background-color: transparent;
    border: none;
    color: #d7d1ac; /* Light gold text */
    font-size: 16px;
    resize: none;
}

/* Sticky note textarea focus styling */
.sticky-note textarea:focus {
    outline: none;
}

/* Sticky note button styling */
.sticky-note button {
    background: #152525; /* Dark background */
    color: #b2ac8a; /* Light beige text */
    border: 1px solid #b2ac8a; /* Border to match text color */
    padding: 10px 15px;
    border-radius: 20px;
    cursor: pointer;
    margin-top: 10px;
    transition: background-color 0.3s ease; /* Smooth background color transition */
}

/* Sticky note button hover styling */
.sticky-note button:hover {
    background-color: #093c31; /* Darker greenish shade for hover */
}

/* Adjust font size and zoom for smaller screens */
@media only screen and (max-width: 600px) {
    body {
        font-size: 14px; /* Smaller font size for smaller screens */
        margin-top: -20px;
    }
    .container {
        padding: 10px; /* Adjust padding or margins if needed */
    }
    .sticky-note {
        display: none;
    }
}

</style>

<script>
    function saveNote() {
        const noteText = document.getElementById('noteText').value;
        const xhr = new XMLHttpRequest();
        xhr.open('POST', 'save_note.php', true);
        xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
        xhr.onload = function() {
            if (xhr.status === 200) {
                alert('Note saved successfully!');
            } else {
                alert('Failed to save note');
            }
        };
        xhr.send('note=' + encodeURIComponent(noteText));
    }
</script>

<div class="chart-and-note">
    <canvas id="statsChart"></canvas>

</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    const ctx = document.getElementById('statsChart').getContext('2d');

    // Fetching values from PHP
    const investment = <?php echo number_format($investment, 2); ?>;
    const balance = <?php echo number_format($balance, 2); ?>;

    const statsChart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: ['Investment', 'Balance'],
            datasets: [{
                label: 'Financial Data (£)',
                data: [investment, balance],
                backgroundColor: [
                    '#d4af37', // Creamy gold
                    '#6f6242'  // Bronze tone
                ],
                borderColor: [
                    '#d4af37',
                    '#6f6242'
                ],
                borderWidth: 2
            }]
        },
        options: {
            responsive: true,
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        color: '#d4af37' // Creamy gold for labels
                    },
                    grid: {
                        color: '#333' // Darker grid color to match theme
                    }
                },
                x: {
                    ticks: {
                        color: '#d4af37' // Creamy gold for labels
                    },
                    grid: {
                        color: '#333' // Darker grid color to match theme
                    }
                }
            },
            plugins: {
                legend: {
                    labels: {
                        color: '#d4af37' // Creamy gold for legend
                    }
                }
            },
            backgroundColor: '#121212'
        }
    });
</script>
</div>

<div class="r2">
    <?php include 'statisticsuser.php'; ?>
</div>
</body>
</html>
